Attribute VB_Name = "blendAllEdges"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

'Visual Basic example  to blend all edges of a given design using the specified blend radius
'and the blend feature name on the active document.
'The example filters the smooth edges of the design and can be used to blend those edges which are not smooth i.e which have not been
'blended earlier.
'The example also checks if the blend operation is possible for a given design and proceeds if it is so.

Global blendRadius As Double
Global blendName As String
Const pause As Boolean = False
Global selectiveEdgeSet As New Collection

Sub BlendAllEdgesExample()

'Call the function SetDataForBlend in order to set the values of blendRadius and blendName
Call SetDataForBlend
'Call the function blendAllEdges in order to blend all the edges of the given design
Call blendAllEdges

MsgBox ("Blending of the given solid is Over")

End Sub

Private Function SetDataForBlend()

'Set the values for blendRadius,blendName
Dim message As String
message = "Please Enter the blend radius in meters"
blendRadius = InputBox(message, "Blend Radius")

Let blendName = "blend"

End Function

Private Function blendAllEdges()

'Get the ProDESKTOP Application object
Dim app As ProDESKTOP
Set app = GetObject("", "ProDESKTOP.Application")
app.SetVisible True

'Exit if part document is not present
Dim part As PartDocument
On Error GoTo NoDoc
Set part = app.GetActiveDoc

'Take the helm
Dim api As helm
Set api = app.TakeHelm

'Get the design
Dim design As aDesign
Set design = part.GetDesign

'Exit if design is nothing
If design Is Nothing Then
   MsgBox "Could not get the Design", vbOKOnly, "Error"
   Exit Function
End If

'Get the edges of the design
Dim edgeset As ObjectSet
Set edgeset = design.GetEdges

'Exit if the edgeSet does not contain edges
If edgeset.IsEmpty Then
    MsgBox "No edges found", vbOKOnly, "Error"
    Exit Function
End If

'Create an IteratorClass and a setClass
Dim itCls As ItClass
Set itCls = app.GetClass("It")

Dim setCls As ObjectSetClass
Set setCls = app.GetClass("ObjectSet")

'Filter the smooth edges of the design
Dim edgeSetIt As Iterator
Set edgeSetIt = itCls.CreateAObjectIt(edgeset)

Dim properEdgeSet As ObjectSet
Set properEdgeSet = setCls.CreateAObjectSet()

edgeSetIt.start

Do While edgeSetIt.IsActive

    bIsSmooth = edgeSetIt.Current.IsSmooth
    If Not bIsSmooth Then
        properEdgeSet.AddMember edgeSetIt.Current
    End If
    
    edgeSetIt.Next
    
Loop

'Exit if the properEdgeSet does not contain edges
If properEdgeSet.IsEmpty Then
    MsgBox "Egdes are already smooth", vbOKOnly, "Error"
    Exit Function
End If

'Create an BlendClass
Dim blendCls As BlendClass
Set blendCls = app.GetClass("Blend")
   
'Create a blend operation
Dim blend1 As aOperation
Set blend1 = blendCls.CreateBlend(design, properEdgeSet, False, 0, blendRadius, 0)
blend1.SetName blendName
part.UpdateDesign

'Check if it is possible to apply the blend for the given solid.
Dim bNeedsGenerating As Boolean
bNeedsGenerating = design.NeedsRegenerating
If bNeedsGenerating Then
    MsgBox "It was not possible to apply the blend", vbOKOnly, "Error"
    If Not blend1 Is Nothing Then
       blend1.Delete
       part.UpdateDesign
    End If
End If

'Use the api commitcalls to update the view
api.CommitCalls "BlendAllEdges", pause

Exit Function

NoDoc:
    MsgBox "Could not get the active Part document", vbOKOnly, "Error"
    Exit Function
    
End Function


